package com.bytesbee.mysinglelivechannel.utils;

import static com.bytesbee.mysinglelivechannel.utils.Constant.DEFAULT_UPDATE_URL;
import static com.bytesbee.mysinglelivechannel.utils.Constant.FALSE;
import static com.bytesbee.mysinglelivechannel.utils.Constant.IMAGE_LOGO_PATH;
import static com.bytesbee.mysinglelivechannel.utils.Constant.IMAGE_UPLOAD;
import static com.bytesbee.mysinglelivechannel.utils.Constant.ONE;
import static com.bytesbee.mysinglelivechannel.utils.Constant.TRUE;
import static com.bytesbee.mysinglelivechannel.utils.Constant.TYPE_YOUTUBE;
import static com.bytesbee.mysinglelivechannel.utils.Constant.ZERO;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Color;
import android.net.ConnectivityManager;
import android.net.NetworkCapabilities;
import android.net.Uri;
import android.os.Handler;
import android.os.Message;
import android.text.Html;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Display;
import android.view.View;
import android.view.Window;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.widget.ImageView;
import android.widget.LinearLayout;

import androidx.annotation.NonNull;

import com.bumptech.glide.Glide;
import com.bytesbee.mysinglelivechannel.BuildConfig;
import com.bytesbee.mysinglelivechannel.R;
import com.bytesbee.mysinglelivechannel.api.ApiInterface;
import com.bytesbee.mysinglelivechannel.api.RestAdapter;
import com.bytesbee.mysinglelivechannel.callbacks.CallbackSettings;
import com.bytesbee.mysinglelivechannel.managers.SessionManager;
import com.bytesbee.mysinglelivechannel.models.Channel;
import com.bytesbee.mysinglelivechannel.models.Setting;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.AdView;
import com.google.android.gms.ads.FullScreenContentCallback;
import com.google.android.gms.ads.LoadAdError;
import com.google.android.gms.ads.interstitial.InterstitialAd;
import com.google.android.gms.ads.interstitial.InterstitialAdLoadCallback;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class Utils {

    public static final String BANNER_AD = "ca-app-pub-3940256099942544/6300978111";
    public static final String INTER_AD = "ca-app-pub-3940256099942544/1033173712";

    public static String getAPIUrl(Context context) {
        return context.getString(R.string.api_url);
    }

    public static String getAPIKey(Context context) {
        return context.getString(R.string.api_key);
    }

    public static String getFCMUrl(final Context context, final String token) {
        return getAPIUrl(context) + "/register.php?token=" + token;
    }

    public static void getErrors(final Exception e) {
        final String stackTrace = Log.getStackTraceString(e);
        Utils.sout(" Error : " + stackTrace);
    }

    public static void sout(final String msg) {
        if (Constant.IS_TRIAL) {
            System.out.println("Prashant :: " + msg);
        }
    }

    public static boolean isEmpty(final Object s) {
        if (s == null) {
            return true;
        }
        if ((s instanceof String) && (((String) s).trim().isEmpty())) {
            return true;
        }
        if (s instanceof Map) {
            return ((Map<?, ?>) s).isEmpty();
        }
        if (s instanceof List) {
            return ((List<?>) s).isEmpty();
        }
        if (s instanceof Object[]) {
            return (((Object[]) s).length == ZERO);
        }
        return false;
    }

    public static void RTLSupport(Window window) {
        try {
            window.getDecorView().setLayoutDirection(View.LAYOUT_DIRECTION_RTL);
        } catch (Exception e) {
            Utils.getErrors(e);
        }
    }

    /**
     * Checking Internet connection is available.
     */
    public static boolean isOnline(final Context context) {
        final ConnectivityManager cm = (ConnectivityManager) context.getSystemService(Context.CONNECTIVITY_SERVICE);
        if (cm != null) {
            NetworkCapabilities capabilities = cm.getNetworkCapabilities(cm.getActiveNetwork());
            if (capabilities != null) {
                return capabilities.hasTransport(NetworkCapabilities.TRANSPORT_WIFI) || capabilities.hasTransport(NetworkCapabilities.TRANSPORT_CELLULAR);
            }
        }
        return false;
    }

    public static boolean isValidateEmail(final String email) {
        final Pattern pattern = Pattern.compile(".+@.+\\.[a-z]+");
        final Matcher matcher = pattern.matcher(email);
        return matcher.matches();
    }

    public static void requestSettingApi(final Context context) {
        requestSettingApi(context, null);
    }

    public static void requestSettingApi(final Context context, final Handler handler) {
        try {
            final ApiInterface apiInterface = RestAdapter.createAPI(context);
            final Call<CallbackSettings> callbackCall = apiInterface.getSettings(Utils.getAPIKey(context));
            callbackCall.enqueue(new Callback<>() {
                @Override
                public void onResponse(@NonNull Call<CallbackSettings> call, @NonNull Response<CallbackSettings> response) {
                    CallbackSettings resp = response.body();
                    Message message = Message.obtain();
                    if (resp != null && resp.status.equals(Constant.SUCCESS)) {
                        SessionManager.get().setSettingModel(resp.data);
                        message.what = Constant.HANDLER_SUCCESS;
                    } else {
                        message.what = Constant.HANDLER_FAILURE;
                    }
                    if (handler != null) {
                        message.setTarget(handler);
                        message.sendToTarget();
                    }
                }

                @Override
                public void onFailure(@NonNull Call<CallbackSettings> call, @NonNull Throwable t) {
                    Utils.sout(t.getMessage());
                    if (handler != null) {
                        Message message = Message.obtain();
                        message.setTarget(handler);
                        message.what = Constant.HANDLER_FAILURE;
                        message.sendToTarget();
                    }
                }
            });
        } catch (Exception e) {
            Utils.getErrors(e);
        }
    }

    public static boolean isEnabledMandatoryLogin() {
        if (SessionManager.get().getSettingModel() != null) {
            return SessionManager.get().getSettingModel().getApp_mandatory_login() == ONE ? TRUE : FALSE;
        } else {
            return FALSE;
        }

    }

    public static void setDescriptionWebView(final Context context, final Channel obj, final WebView txtDescription) {
        try {

            txtDescription.setBackgroundColor(Color.parseColor("#f2f2f2"));
            txtDescription.setFocusableInTouchMode(FALSE);
            txtDescription.setFocusable(FALSE);
            txtDescription.getSettings().setDefaultTextEncodingName("UTF-8");

            WebSettings webSettings = txtDescription.getSettings();
            Resources res = context.getResources();
            int fontSize = res.getInteger(R.integer.font_size);
            webSettings.setDefaultFontSize(fontSize);

            String mimeType = "text/html; charset=UTF-8";
            String encoding = "utf-8";
            String htmlText = obj.channel_description;
            String rtl = SessionManager.get().isRTLOn() ? "dir=\"rtl\"" : "";

            String text = "<html><head>"
                    + "<style type=\"text/css\">@font-face {font-family: MyFont;src: url(\"file:///android_res/font/poppins_regular.otf\")}body{font-family: MyFont;color: #525252;}"
                    + "</style></head>"
                    + "<body " + rtl + ">"
                    + htmlText
                    + "</body></html>";

            txtDescription.loadDataWithBaseURL(null, text, mimeType, encoding, null);
        } catch (Exception e) {
            Utils.getErrors(e);
        }

    }

    public static void setChannelImageView(Context context, Channel channel, int index, ImageView imgChannel) {
        try {
            if (channel.channel_type.equalsIgnoreCase(TYPE_YOUTUBE)) { //&& !ytImage.equalsIgnoreCase("")) {
                //final String youtubeImg = YOUTUBE_IMG + ytImage + DEFAULT_YOUTUBE_IMG;
                final String youtubeImg = index == ZERO ? channel.getYoutube_image() : channel.getYoutube_image_two();
                //final String youtubeImg = channel.getYoutube_image();
                Glide.with(context)
                        .load(youtubeImg)
                        .placeholder(R.drawable.image_load)
                        .into(imgChannel);
            } else { //if (ytImage.equalsIgnoreCase("")) {
                Glide.with(context)
                        .load(getAPIUrl(context) + IMAGE_UPLOAD + channel.getChannel_image())
                        .placeholder(R.drawable.image_load)
                        .into(imgChannel);
            }
        } catch (Exception e) {
            Utils.getErrors(e);
        }
    }

    public static void setSettingImageView(Context context, Setting setting, ImageView imgAppLogo) {
        try {
            Glide.with(context)
                    .load(getAPIUrl(context) + IMAGE_LOGO_PATH + setting.getApp_logo())
                    .placeholder(R.drawable.image_load)
                    .into(imgAppLogo);
        } catch (Exception e) {
            Glide.with(context)
                    .load(R.mipmap.ic_launcher)
                    .placeholder(R.mipmap.ic_launcher)
                    .into(imgAppLogo);
        }
    }

    public static String Format(final Integer number) {
        final String[] suffix = new String[]{"k", "m", "b", "t"};
        int size = (number != 0) ? (int) Math.log10(number) : 0;
        if (size >= 3) {
            while (size % 3 != 0) {
                size = size - 1;
            }
        }
        double notation = Math.pow(10, size);
        return (size >= 3) ? (Math.round((number / notation) * 100) / 100.0d) + suffix[(size / 3) - 1] : number + "";
    }

    public static void shareApp(final Activity mActivity, final String title) {
        final String app_name = android.text.Html.fromHtml(title, Html.FROM_HTML_MODE_LEGACY).toString();
        final String share_text = android.text.Html.fromHtml(mActivity.getResources().getString(R.string.strShareContent), Html.FROM_HTML_MODE_LEGACY).toString();
        final Intent sendIntent = new Intent();
        sendIntent.setAction(Intent.ACTION_SEND);
        sendIntent.putExtra(Intent.EXTRA_TEXT, app_name + "\n\n" + share_text + "\n\n" + DEFAULT_UPDATE_URL + mActivity.getPackageName());
        sendIntent.setType("text/plain");
        mActivity.startActivity(sendIntent);
    }

    public static void shareApp(final Activity mActivity) {
        shareApp(mActivity, mActivity.getResources().getString(R.string.strShareTitle));
    }

    public static int getAppVersionCode(Context context) {
        int appVersionDetails = 1;
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            appVersionDetails = packageInfo.versionCode;
        } catch (PackageManager.NameNotFoundException e) {
            Utils.getErrors(e);
        }
        return appVersionDetails;
    }

    public static String getAppVersionName() {
        return BuildConfig.VERSION_NAME;
    }

    public static void openStore(Context context, String updateUrl, boolean isClosedApp) {
        final Intent intent = new Intent(Intent.ACTION_VIEW, Uri.parse(updateUrl));
        intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        context.startActivity(intent);
        if (isClosedApp)
            ((Activity) context).finish();
        try {
            ((Activity) context).overridePendingTransition(android.R.anim.fade_in, android.R.anim.fade_out);
        } catch (Exception ignored) {
        }
    }

    public static Bitmap getBitmapFromURL(final String strURL) {
        try {
            final URL url = new URL(strURL);
            HttpURLConnection httpURLConnection = (HttpURLConnection) url.openConnection();
            httpURLConnection.setDoInput(true);
            httpURLConnection.connect();
            InputStream inputStream = httpURLConnection.getInputStream();
            return BitmapFactory.decodeStream(inputStream);
        } catch (IOException e) {
            Utils.getErrors(e);
            return null;
        }
    }

    public static void showBannerAd(final Activity mActivity) {
        try {
            final LinearLayout layout = mActivity.findViewById(R.id.adsBottomView);
            layout.setVisibility(View.VISIBLE);
            final Setting setting = SessionManager.get().getSettingModel();
            if (setting != null) {
                if (setting.getBanner_ad() == Constant.VISIBLE) {
                    //For testing purpose only, if you need to look the TEST ADS, just uncomment below code and when you get the ads, then don't forget to comment the below code
                    if (Constant.TEST_ADS) {
                        setting.setBanner_ad_id(BANNER_AD);
                    }
                    EasyAdsDynamic.MainAppId(mActivity);
                    final AdView mAdView = new AdView(mActivity);
                    layout.removeAllViews();
                    EasyAdsDynamic.forBanner(mActivity)
                            .withLayout(layout, mAdView)
                            .listener(new AdListener() {
                                @Override
                                public void onAdFailedToLoad(@NonNull LoadAdError loadAdError) {
                                    super.onAdFailedToLoad(loadAdError);
                                    Utils.sout("onAdFailedToLoad:: " + loadAdError.getMessage());
                                }

                                @Override
                                public void onAdLoaded() {
                                    super.onAdLoaded();
                                }
                            })
                            .adUnitId(setting.getBanner_ad_id())
                            //.adSize(AdSize.FULL_BANNER)
                            .adSize(getAdSize(mActivity))
                            .show();
                } else {
                    layout.setVisibility(View.GONE);
                }
            } else {
                layout.setVisibility(View.GONE);
            }
        } catch (Exception ignored) {
        }
    }

    public static int LAUNCHED_AD = ZERO;
    private static InterstitialAd mInterstitialAd;

    public static void loadFirstTimeInterstitialAds(Activity mActivity) {
        final Setting setting = SessionManager.get().getSettingModel();

        if (setting != null) {
            //For testing purpose only, if you need to look the TEST ADS, just uncomment below code and when you get the ads, then don't forget to comment the below code
            if (Constant.TEST_ADS) {
                setting.setInterstital_ad_id(INTER_AD);
            }
            InterstitialAd.load(mActivity, setting.getInterstital_ad_id(), new AdRequest.Builder().build(), new InterstitialAdLoadCallback() {
                @Override
                public void onAdLoaded(@NonNull InterstitialAd interstitialAd) {
                    super.onAdLoaded(interstitialAd);
                    mInterstitialAd = interstitialAd;
                    interstitialAd.setFullScreenContentCallback(new FullScreenContentCallback() {
                        @Override
                        public void onAdShowedFullScreenContent() {
                            super.onAdShowedFullScreenContent();
                            mInterstitialAd = null;
                        }

                        @Override
                        public void onAdDismissedFullScreenContent() {
                            mInterstitialAd = null;
                            loadFirstTimeInterstitialAds(mActivity);
                        }
                    });
                }

                @Override
                public void onAdFailedToLoad(@NonNull LoadAdError loadAdError) {
                    // Handle the error
                    mInterstitialAd = null;
                }

            });
        }

    }

    public static void showInterstitialAds(Activity mActivity) {
        final Setting setting = SessionManager.get().getSettingModel();
        if (setting != null) {
            if (setting.getInterstital_ad() == Constant.VISIBLE) {
                if (setting.getInterstital_ad_click() <= LAUNCHED_AD) {
                    LAUNCHED_AD = ZERO;
                    if (mInterstitialAd != null) {
                        mInterstitialAd.show(mActivity);
                    }
                } else {
                    LAUNCHED_AD++;
                }
            }
        }

    }

    private static AdSize getAdSize(final Activity mActivity) {
        // Step 2 - Determine the screen width (less decorations) to use for the ad width.
        Display display = mActivity.getWindow().getWindowManager().getDefaultDisplay();
        DisplayMetrics outMetrics = new DisplayMetrics();
        display.getMetrics(outMetrics);

        float widthPixels = outMetrics.widthPixels;
        float density = outMetrics.density;

        int adWidth = (int) (widthPixels / density);

        // Step 3 - Get adaptive ad size and return for setting on the ad view.
        return AdSize.getCurrentOrientationAnchoredAdaptiveBannerAdSize(mActivity, adWidth);
    }

}
